//ESTRUCTURAS EXPUESTAS AL EXTERIOR

typedef struct{
	uint8m modo_ajuste;	//ATMODOAJUSTE_... en Aerotri_defs.h
	uint8m modo_toma;		//0, no se sabe; ATMODOTOMA_... en Aerotri_defs.h
	uint8m modo_medida;	//0, no se sabe; ATMODOMEDIDA_... en Aerotri_defs.h
} Trabajo_Modos;

typedef struct{
	char16_t* fotos,
		*aproximadas,
		*apoyo,
		*gpsins,
		*camara;
	uint8m generar;	//Generar fichero con formato de Aerotri si el de entrada no lo es. flags
} Trabajo_Ficheros;

typedef struct{
	uint8m tfot, tapr, tapy, tgps, tint,
			tdapr;
} Trabajo_TipoFicheros;

#define ATTrabajo_TDGPS_Offset		GrupoGPSINS_TDGPS_Offset
#define ATTrabajo_TDGPS_NoError	0
#define ATTrabajo_TDGPS_Constant	1
#define ATTrabajo_TDGPS_Linear		2
typedef struct{
	uint8m tdgps, tdins;	//Values above: Offset, no error, constant, lienar
	bool8 signoins;
} Trabajo_DatosGPS;

typedef struct{
	double kUTM, kLambert;
	double XUTM,YUTM, XLambert,YLambert;
	ssint Phi0Lambert;		//El valor en milésismas de segundo
	bool8 LatLong;		//0 si el orden es phi,lambda; 1 si es lambda,phi.
} TSistema_ValoresProy;

typedef struct{
	double N,rho,conv,k;
} TSistema_Tierra;

typedef struct{
	uint nsistema;	//0 Rectangular, etc.
	uint8m elipsoide;	//0: Esfera, 1: otro, 2-6: predefinido en ElipsoidesValores[elipsoide-2]
	float ondulacion;
	struct{double a,ee;} elipsoideotro;
	TSistema_Tierra tierra;
	TSistema_ValoresProy valoressistemas;
} Trabajo_Sistema;

static const float predefined_limites[4][10]={
	{1.5F,	1.71F,	1.91F,	2.09F,	2.26F,	2.425F,2.58F,	2.725F,	2.865F,	3.0F},
	{1.8F,	2.0F,	2.19F,	2.36F,	2.52F,	2.67F,	2.81F,	2.95F,		3.08F,	3.2F},
	{2.8F,	3.0F,	3.2F,	3.4F,	3.6F,	3.8F,	4.0F,	4.2F,		4.4F,	4.6F},
	{3.1F,	3.31F,	3.53F,	3.76F,	4.0F,	4.25F,	4.51F,	4.78F,		5.06F,	5.35F}
};

#define ATTrabajo_GiroINS180_Camara 0
#define ATTrabajo_GiroINS180_Fichero 1
typedef struct{
	uint8m unigiros;	//Véanse los posibles valores en Aerotri_defs.h
	bool8 reescribe_cpp;
	uint8m estimador;	//Predefinidos. V. posibles valores en clases_estimadores.h
	bool8 bgirok;		//Si un giro de 180º respecto al INS significa que la foto fue girada
	bool8 fijas;			//Apoyo variable
	bool8 completo;
	uint8m interp_gps;	//0, no; 1, sólo interpolar; 2, también extrapolar
	bool8 interp_resgps;
	uint8m escalaresiduos;	//0,1,2,3, ((uint8m)-1). Si  0<=valor<=3, es una de las series predefinidas en predefined_limites.
	float residuos_escala[20];	//Si es -1 es otra cualquiera. En cualquier caso los valores han de estar en residuos_escala,
} Trabajo_Opciones;			//cerrados por un NAN o INFINITY.

typedef struct{
	bool8 existe;
	struct{
		bool8 f;
		bool8 pp;
		bool8 distorsion;
		struct{
			bool8 radsim;
			bool8 tansim;
			bool8 asimetricas;
		} componentes;
	} selected;
	Config_distorsion config_dist;
} Trabajo_AutoCalib;

typedef struct{
	bool8 log_ajuste;		//Fichero de log para el ajuste
	bool8 log_pdfs;		//Mantener los logs de generación de los pdfs (de TeX)
	u16int log_level;	//Nivel de log para ajbloque y relativa
	bool8 muestra_html;	//Mostrar html tras el cálculo
} Trabajo_Salida;

struct strTrabajoAerotri{
	uint8m sensor;	//0, cónico; 1, modelo local (usar siempre 0)
	Trabajo_Modos modos;
	Trabajo_Ficheros ficheros;
	Trabajo_TipoFicheros tiposf;
	Trabajo_DatosGPS datosgps;
	EstimacionConjuntas conjuntas;
	Trabajo_AutoCalib autocalib;
	ValoresAproximados valoresaproximados;
	Precisiones apriori;	//NaN o infinito signfica que no se indicó nigún valor
	Trabajo_Opciones opciones;
	Trabajo_Sistema sistema;
	AjbloqueConfigSalida configsalida;
	Trabajo_Salida salidatrabajo;
};
